/* file.c   by Michael Thorpe   2002-05-02 */

#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "ftpd.h"

#if MAX_OUT_BUF < 2*BUF_SIZE
#error "MAX_OUT_BUF must not be smaller than BUF_SIZE!"
#endif

static int store_cb(conn *c) {
   char *buf;
   size_t l;
   int z;

   z=451;
   if(c->state>=STATE_ABORT)
      goto fail;
   buf=(char *)malloc(BUF_SIZE);
   if(!buf)
      goto fail;
tryagain:
   l=read(c->fdd,buf,BUF_SIZE);
   if(l==-1) {
      if(errno==EINTR)
         goto tryagain;
      if(errno==EAGAIN)
         goto giveitamiss;
      goto failfree;
   }
   if(l==0)
      goto done;
   resettimeout(c);
   if(c->type=='A')
      l=a2b(buf,l);
   if(writeall(c->fdf,buf,l))
      goto failfree;
giveitamiss:
   free(buf);
   return(0);
done:
   z=0;
failfree:
   free(buf);
fail:
   if(close(c->fdf))
      z=451;
   c->fdf=-1;
   c->callback=0;
   return(dclose(c,z));
}

int do_store(conn *c,char *arg,int flags) {
   if(syncfsid(c))
      return(1);
   c->fdf=open(arg,O_WRONLY|O_CREAT|O_NOCTTY|flags,0666);
   if(c->fdf==-1)
      return(putline(c,550,0));
   if(log(c,LOG_STORE,arg)) {
      close(c->fdf);
      return(putline(c,451,0));
   }
   c->direction=DSTATE_IN;
   if(dopen(c)) {
      close(c->fdf);
      return(putline(c,425,0));
   }
   c->callback=store_cb;
   return(0);
}

int cmd_appe(conn *c,char *arg) {
   return(do_store(c,arg,O_APPEND));
}

int cmd_dele(conn *c,char *arg) {
   if(syncfsid(c))
      return(1);
   if(unlink(arg))
      return(putline(c,550,0));
   return(putline(c,250,0));
}

static int retr_cb(conn *c) {
   char *buf;
   size_t l;
   int z=451;

   if(c->state>=STATE_ABORT)
      goto fail;
   while(davail(c,2*BUF_SIZE)) {
      buf=(char *)malloc(2*BUF_SIZE);
      if(!buf) {
/* FIXME: This should be a 451 then 226 (and there may be others like it!) */
         putline(c,426,0);
         z=0;
         goto fail;
      }
      l=read(c->fdf,buf,BUF_SIZE);
      if(l==-1)
         goto failfree;
      if(l==0)
         goto done;
      if(c->type=='A')
         l=b2a(buf,l);
      if(dwrite(c,buf,l))
         goto failfree;
      free(buf);
   }
   return(0);
done:
   z=0;
failfree:
   free(buf);
fail:
   if(close(c->fdf))
      z=451;
   c->fdf=-1;
   if(z) {
      c->callback=0;
      return(dclose(c,z));
   }
   c->callback=dflush;
   return(dflush(c));
}

int cmd_retr(conn *c,char *arg) {
   if(syncfsid(c))
      return(1);
   c->fdf=open(arg,O_RDONLY|O_NOCTTY);
   if(c->fdf==-1)
      return(putline(c,550,0));
   if(log(c,LOG_RETRIEVE,arg)) {
      close(c->fdf);
      return(putline(c,451,0));
   }
   c->direction=DSTATE_OUT;
   if(dopen(c)) {
      close(c->fdf);
      return(putline(c,425,0));
   }
   c->callback=retr_cb;
   return(0);
}

int cmd_rnfr(conn *c,char *arg) {
   struct stat ss;

   if(syncfsid(c))
      return(1);
   if(lstat(arg,&ss))
      return(putline(c,550,0));
   if(c->rnfr)
      free(c->rnfr);
   c->rnfr=strdup(arg);
   if(!c->rnfr)
      return(1);
   return(putline(c,350,0));
}

int cmd_rnto(conn *c,char *arg) {
   if(syncfsid(c))
      return(1);
   if(rename(c->rnfr,arg))
      return(putline(c,553,0));
   return(putline(c,250,0));
}

int cmd_stor(conn *c,char *arg) {
   return(do_store(c,arg,O_TRUNC));
}

