/* cmd.c   by Michael Thorpe   2003-08-02 */

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "ftpd.h"

struct command {
   char *cmd;
   int privs;
   int (*func)(conn *,char *);
   char *desc;
};

extern struct command cmds[];

static int cmd_unavail(conn *c,struct command *cmd) {
   if(!c->user && cmd->privs&CMD_LOGGEDIN)
      return(530);
   if(c->callback && !(cmd->privs&CMD_SIMULT))
      return(503);
   if(!c->username && cmd->privs&CMD_USERNAME)
      return(503);
   if(!c->rnfr && cmd->privs&CMD_RNFR)
      return(503);
   return(0);
}

int cmd_superfluous(conn *c,char *arg) {
   return(putline(c,202,0));
}

int cmd_abor(conn *c,char *arg) {
/* FIXME: To be written */
   return(1);
}

int cmd_help(conn *c,char *arg) {
   int i,j,k;
   char *s,*t;

   s=strdup("Help text follows:\r\n");
   if(!s)
      return(-1);
   j=strlen(s);
   for(i=0;cmds[i].cmd[0];i++) {
      if(arg[0] && strcasecmp(arg,cmds[i].cmd))
         continue;
      if(cmd_unavail(c,&cmds[i]))
         continue;
      k=strlen(cmds[i].cmd);
      j+=3+((5>k)?5:k)+strlen(cmds[i].desc);
      t=(char *)realloc(s,j+1);
      if(!t) {
         free(s);
         return(-1);
      }
      s=t;
      strcat(s,cmds[i].cmd);
      if(5>k)
         strcat(s,k+"     ");
      strcat(s," ");
      strcat(s,cmds[i].desc);
      strcat(s,"\r\n");
   }
   while(s[j-1]=='\n' || s[j-1]=='\r')
      s[--j]='\0';
   i=putline(c,214,s);
   free(s);
   return(i);
}

int cmd_mode(conn *c,char *arg) {
   if(!arg[0] || arg[1])
      return(putline(c,501,0));
   switch(toupper(arg[0])) {
   case 'S':
      c->mode='S';
      return(putline(c,200,"Mode set to Stream"));
   }
   return(putline(c,504,0));
}

int cmd_noop(conn *c,char *arg) {
   return(putline(c,200,0));
}

int cmd_port(conn *c,char *arg) {
   unsigned short port;
   const char *s;
   unsigned char a[4];
   char addr[16];

   if(parseaddr(arg,&s,a))
      return(putline(c,501,0));
   if(!*s)
      return(putline(c,501,0));
   if(parseport(s,&s,&port))
      return(putline(c,501,0));
   if(*s)
      return(putline(c,501,0));
   sprintf(addr,"%u.%u.%u.%u",a[0],a[1],a[2],a[3]);
   if(strcmp(c->raddr,addr))
      return(putline(c,501,0));
   if(c->fdd>=0)
      dclose(c,0);
   c->drport=port;
   c->dstate=DSTATE_ACTIVE;
   return(putline(c,200,0));
}

int cmd_quit(conn *c,char *arg) {
   if(c->fdd>=0)
      dclose(c,0);
   if(putline(c,221,0))
      return(1);
   c->state=STATE_CLOSE;
   return(0);
}

int cmd_stru(conn *c,char *arg) {
   if(!arg[0] || arg[1])
      return(putline(c,504,0));
   switch(toupper(arg[0])) {
   case 'F':
      c->structure='F';
      return(putline(c,200,"File structure set to none"));
   case 'R':
      c->structure='R';
      return(putline(c,200,"File structure set to record"));
   case 'P':
      c->structure='P';
      return(putline(c,200,"File structure set to page"));
   }
   return(putline(c,504,0));
}

int cmd_syst(conn *c,char *arg) {
   return(putline(c,215,"UNIX Type: L8"));
}

int cmd_type(conn *c,char *arg) {
   int i;

   if(!isalpha(arg[0]))
      return(putline(c,501,0));
   for(i=1;isspace(arg[i]);i++)
      ;
   switch(toupper(arg[0])) {
   case 'A':
      if(arg[i] && arg[i+1])
         return(putline(c,501,0));
      switch(toupper(arg[i])) {
      case '\0':
      case 'N':
         c->type='A';
         c->subtype='N';
         return(putline(c,200,"Transfer type set to ASCII Non-print"));
      case 'T':
         c->type='A';
         c->subtype='T';
         return(putline(c,200,"Transfer type set to ASCII telnet format effectors"));
      default:
         return(putline(c,504,0));
      }
   case 'E':
      return(putline(c,504,0));
   case 'I':
      if(arg[1])
         return(putline(c,501,0));
      c->type='I';
      c->subtype='\0';
      return(putline(c,200,"Transfer type set to Image"));
   case 'L':
      if(!isdigit(arg[i]) || (i=strtoul(arg+i,&arg,10),*arg))
         return(putline(c,501,0));
      c->type='I';
      c->subtype=i;
      return(putline(c,200,"Transfer type set to L"));
   default:
      return(putline(c,504,0));
   }
}

static char *logquote(const char *line) {
   int i,j;
   char *s;

   j=strlen(line);
   s=(char *)malloc(2*j+1);
   if(!s)
      return(0);
   for(i=j=0;line[i];i++) {
      if(line[i]=='\n') {
         s[j++]='\\';
         s[j++]='\n';
      } else if(line[i]=='\r') {
         s[j++]='\\';
         s[j++]='\r';
      } else if(line[i]=='\\') {
         s[j++]='\\';
         s[j++]='\\';
      } else if(isprint(line[i])) {
         s[j++]=line[i];
      } else {
         s[j++]='\\';
         s[j++]='0'+((((unsigned char)line[i])>>6));
         s[j++]='0'+((((unsigned char)line[i])>>3)&7);
         s[j++]='0'+((((unsigned char)line[i])   )&7);
      }
   }
   s[j]='\0';
	return(s);
}

int do_cmd(conn *c,char *line) {
   int i,j,k;
	char *tmp;

   for(i=0;strncasecmp(line,cmds[i].cmd,j=strlen(cmds[i].cmd));i++)
      ;
   if(j==4 && !strncasecmp(line,"PASS",4) && (line[4]==' ' || line[4]=='\t'))
      log(c,LOG_COMMAND,"PASS <hidden>");
   else {
		tmp=logquote(line);
		if(!tmp)
			return(1);
      log(c,LOG_COMMAND,tmp);
		free(tmp);
	}
   if(!j)
      return(putline(c,500,0));
   if(line[j] != ' ' && line[j] != '\0' && line[j] != '\t')
      return(putline(c,500,0));
   k=cmd_unavail(c,&cmds[i]);
   if(k)
      return(putline(c,k,0));
   while(line[j]==' ' || line[j]=='\t')
      j++;
   if(line[j] != '\0' && cmds[i].privs&CMD_NOARG)
      return(putline(c,501,0));
   if(line[j] == '\0' && cmds[i].privs&CMD_NEEDSARG)
      return(putline(c,501,0));
   resettimeout(c);
   return((*cmds[i].func)(c,&line[j]));
}

struct command cmds[]={
   {"ACCT",CMD_LOGGEDIN,cmd_superfluous,"Do nothing, but return 202"},
   {"ALLO",CMD_LOGGEDIN,cmd_superfluous,"Do nothing, but return 202"},
   {"APPE",CMD_NEEDSARG|CMD_LOGGEDIN,cmd_appe,"Store file (don't truncate)"},
   {"CDUP",CMD_NOARG|CMD_LOGGEDIN|CMD_SIMULT,cmd_cdup,"Change to parent directory"},
   {"CWD",CMD_NEEDSARG|CMD_LOGGEDIN|CMD_SIMULT,cmd_cwd,"Change directory"},
   {"DELE",CMD_NEEDSARG|CMD_LOGGEDIN|CMD_SIMULT,cmd_dele,"Remove file"},
   {"HELP",CMD_SIMULT,cmd_help,"Show help"},
   {"LIST",CMD_LOGGEDIN,cmd_list,"Show names and stats (matching optional arg)"},
   {"MKD",CMD_NEEDSARG|CMD_LOGGEDIN|CMD_SIMULT,cmd_mkd,"Make new directory"},
   {"MODE",CMD_NEEDSARG|CMD_LOGGEDIN,cmd_mode,"Change transfer mode"},
   {"NLST",CMD_LOGGEDIN,cmd_nlst,"Show names (matching optional arg)"},
   {"NOOP",CMD_NOARG|CMD_SIMULT,cmd_noop,"Do nothing"},
   {"PASS",CMD_NEEDSARG|CMD_USERNAME,cmd_pass,"Declare password"},
   {"PASV",CMD_NOARG|CMD_LOGGEDIN,cmd_pasv,"Change server data port and listen"},
   {"PORT",CMD_NEEDSARG|CMD_LOGGEDIN,cmd_port,"Change client data port"},
   {"PWD",CMD_NOARG|CMD_LOGGEDIN|CMD_SIMULT,cmd_pwd,"Return current directory"},
   {"QUIT",CMD_NOARG|CMD_SIMULT,cmd_quit,"Close the connection"},
   {"REIN",CMD_NOARG|CMD_SIMULT,cmd_rein,"Reinitialize the connection"},
   {"RETR",CMD_NEEDSARG|CMD_LOGGEDIN,cmd_retr,"Retrieve file"},
   {"RMD",CMD_NEEDSARG|CMD_LOGGEDIN|CMD_SIMULT,cmd_rmd,"Remove directory"},
   {"RNFR",CMD_NEEDSARG|CMD_LOGGEDIN,cmd_rnfr,"Rename from <name>..."},
   {"RNTO",CMD_NEEDSARG|CMD_LOGGEDIN|CMD_RNFR,cmd_rnto,"...to <name>."},
   {"SMNT",CMD_LOGGEDIN,cmd_superfluous,"Do nothing, but return 202"},
   {"STOR",CMD_NEEDSARG|CMD_LOGGEDIN,cmd_stor,"Store file"},
   {"STRU",CMD_NEEDSARG|CMD_LOGGEDIN,cmd_stru,"Change file structure setting"},
   {"SYST",CMD_NOARG|CMD_LOGGEDIN|CMD_SIMULT,cmd_syst,"Return system name"},
   {"TYPE",CMD_NEEDSARG|CMD_LOGGEDIN,cmd_type,"Change data type"},
   {"USER",CMD_NEEDSARG,cmd_user,"Declare username"},
   {"XCUP",CMD_NOARG|CMD_LOGGEDIN|CMD_SIMULT,cmd_cdup,"Same as CDUP"},
   {"XCWD",CMD_NEEDSARG|CMD_LOGGEDIN|CMD_SIMULT,cmd_cwd,"Same as CWD"},
   {"XMKD",CMD_NEEDSARG|CMD_LOGGEDIN|CMD_SIMULT,cmd_mkd,"Same as MKD"},
   {"XPWD",CMD_NOARG|CMD_LOGGEDIN|CMD_SIMULT,cmd_pwd,"Same as PWD"},
   {"XRMD",CMD_NEEDSARG|CMD_LOGGEDIN|CMD_SIMULT,cmd_rmd,"Same as RMD"},
   {"",0,0,0}
};

