/* log.c   by Michael Thorpe   2003-12-18 */

#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include "ftpd.h"

static FILE *logfile=0;
pid_t curpid;
static char timestring[15];
static time_t timestamp=0;

static char *(logtype[])={"FAIL","NOTICE","LOGIN","CONNECT","DISCNCT","RETR","STOR","COMMAND","REPLY"};

static int preplog() {
   if(!logfile) {
#ifdef DEBUG
      logfile=stdout;
#else
      if(0==(logfile=fopen(LOG_FILE,"a")))
         return(-1);
#endif
   }
   return(0);
}

static void update_timestamp() {
	time_t t;
	struct tm *tm;

	t=time(0);
	if(t != timestamp) {
		tm=localtime(&t);
		strftime(timestring,sizeof(timestring),"%Y%m%d%H%M%S",tm);
	}
}

int log(conn *c,int type,char *s) {
   if(!((1<<type)&LOG_LEVEL))
      return(0);
   if(preplog())
      return(-1);
	update_timestamp();
   if(!fprintf(logfile,"%s\t%u\t%s\t%s\t%s\n",timestring,(unsigned int)curpid,(c&&c->raddr?c->raddr:"-unknown-"),logtype[type],s))
      return(-1);
   fflush(logfile);
   return(0);
}

int log2(conn *c,int type,char *s1,char *s2) {
   if(!((1<<type)&LOG_LEVEL))
      return(0);
   if(preplog())
      return(-1);
	update_timestamp();
   if(!fprintf(logfile,"%s\t%u\t%s\t%s\t%s%s\n",timestring,(unsigned int)curpid,(c&&c->raddr?c->raddr:"-unknown-"),logtype[type],s1,s2))
      return(-1);
   fflush(logfile);
   return(0);
}

int log3(conn *c,int type,char *s1,char *s2,char *s3) {
   if(!((1<<type)&LOG_LEVEL))
      return(0);
   if(preplog())
      return(-1);
	update_timestamp();
   if(!fprintf(logfile,"%s\t%u\t%s\t%s\t%s%s%s\n",timestring,(unsigned int)curpid,(c&&c->raddr?c->raddr:"-unknown-"),logtype[type],s1,s2,s3))
      return(-1);
   fflush(logfile);
   return(0);
}

void reopenlog(int ignored) {
#ifndef DEBUG
   FILE *f;

   if(logfile) {
      if(0==(f=freopen(LOG_FILE,"a",logfile))) {
         fprintf(logfile,"Fatal error! Couldn't reopen logfile!\n");
         fflush(logfile);
         abort();
      }
      if(f != logfile) {
         fprintf(f,"Semi-fatal error! Didn't get same FILE * on log reopen!\n");
         fflush(f);
         logfile=f;
      }
   }
   log(0,LOG_NOTICE,"Reopening logfile");
#endif
   ignored=0;
#if REDO_SIGNALS
   signal(SIGHUP,reopenlog);
#endif
}

