/* ftpd.h   by Michael Thorpe   2004-06-18 */

#include "conf.h"
#include <sys/time.h>

/* Needed for size_t */
#include <stdio.h>
/* Needed for struct timeval */
#include <time.h>
/* Needed for uid_t/gid_t/pid_t */
#include <unistd.h>
/* Needed for struct sockaddr_in */
#include <netinet/in.h>
#if ALLOW_GLOBBING
/* Needed for glob_t */
#include <glob.h>
#else
/* Needed for DIR * */
#include <dirent.h>
#endif

#define LOG_FAIL        0
#define LOG_NOTICE      1
#define LOG_LOGIN       2
#define LOG_CONNECT     3
#define LOG_DISCONNECT  4
#define LOG_RETRIEVE    5
#define LOG_STORE       6
#define LOG_COMMAND     7
#define LOG_REPLY       8
/* Technically, this should be in conf.h, but oh well... */
#define LOG_LEVEL       (~0)

#define CMD_NOARG     1
#define CMD_NEEDSARG  2
#define CMD_LOGGEDIN  4
#define CMD_SIMULT    8
#define CMD_USERNAME  16
#define CMD_RNFR      32

#define STATE_NORMAL  0
/* We're still in the middle of a command: */
#define STATE_BUSY    1
/* We're trying to abort the command in progress: */
#define STATE_ABORT   2
/* We want this connection closed and deleted now: */
#define STATE_CLOSE   3

#define DMODE_ACTIVE   0
#define DMODE_PASSIVE  1

#define DIRECTION_NONE  0
#define DIRECTION_IN    1
#define DIRECTION_OUT   2

#define DSTATE_CLOSED   0
#define DSTATE_OPENING  1
#define DSTATE_OPEN     2

#define INITIAL_TIMEOUT  60
#define NORMAL_TIMEOUT  600

#define BUF_SIZE     4096
#define MAX_IN_BUF   8192
/* MAX_OUT_BUF must be at least as big as DIR_LINE_MAX */
#define MAX_OUT_BUF  10240

typedef struct listener listener;
struct listener {
   struct listener *prev,*next;
   int fdc;
   char *addr;
   char *external_addr;
   unsigned short cport;
};

typedef struct connection conn;
struct connection {
   conn *prev,*next;
   int fdc;
   int fdd;
   int fdf;
   uid_t uid;
   gid_t gid;
#if !MODE_PERCONN
   char *cwd;
#endif
   int (*callback)(conn *);
   char *cinbuf;
   size_t cinbuflen;
   char *coutbuf;
   size_t coutbuflen;
   char *doutbuf;
   size_t doutbuflen;
   char state;
   char cinstate;
   char dmode;
   char direction;
   char dstate;
   char dostat;
#if ALLOW_GLOBBING
   glob_t glob;
   int globpos;
#else
   DIR *dir;
#endif
   unsigned long timeout;
   struct timeval timeleft;
   char mode;
   char type;
   char subtype;
   char structure;
   char *laddr,*raddr,*external_laddr;
   unsigned short lport,rport;
   unsigned short dlport,drport;
   char *user;
   char *username;
   char *rnfr;
};

/* cmd.c */
int do_cmd(conn *c,char *line);
int cmd_abor(conn *c,char *arg);
/* conio.c */
int cwrite(conn *c,char *s,size_t l);
int putline(conn *c,unsigned int status,char *message);
char *getline(conn *c);
int cin(conn *c);
int cout(conn *c);
/* dataio.c */
int daccept(conn *c);
int dconnect(conn *c);
int dwrite(conn *c,char *buf,size_t len);
int dwriterec(conn *c,char *buf,size_t len);
#define davail(c,l) ((l)+(c)->doutbuflen<MAX_OUT_BUF)
int dflush(conn *c);
int dout(conn *c);
int dopen(conn *c,int direction);
int dclose(conn *c,int failure);
int derror(conn *c);
/* dir.c */
int cmd_cdup(conn *c,char *arg);
int cmd_cwd(conn *c,char *arg);
int cmd_list(conn *c,char *arg);
int cmd_mkd(conn *c,char *arg);
int cmd_nlst(conn *c,char *arg);
int cmd_pwd(conn *c,char *arg);
int cmd_rmd(conn *c,char *arg);
/* file.c */
int cmd_appe(conn *c,char *arg);
int cmd_dele(conn *c,char *arg);
int cmd_retr(conn *c,char *arg);
int cmd_rnfr(conn *c,char *arg);
int cmd_rnto(conn *c,char *arg);
int cmd_stor(conn *c,char *arg);
/* log.c */
extern pid_t curpid;
int log(conn *c,int type,char *s);
int log2(conn *c,int type,char *s1,char *s2);
int log3(conn *c,int type,char *s1,char *s2,char *s3);
void reopenlog(int ignored);
/* net.c */
extern conn *baseconn;
extern listener *baselistener;
int parseaddr(const char *s,const char **post,unsigned char a[4]);
int parseport(const char *s,const char **post,unsigned short *port);
int bindaddrport(const char *addr,unsigned short port);
conn *newconn(int fd,struct sockaddr_in *sar,listener *l);
void delconn(conn *c);
int newlistener(const char *addr,unsigned short port,const char *external_addr);
int dellistener(const char *addr,unsigned short port);
int laccept(listener *l);
int lerror(listener *l);
int cmd_pasv(conn *c,char *arg);
/* select.c */
void doloop();
/* user.c */
int syncfsid(conn *c);
int dropuserid();
int cmd_rein(conn *c,char *arg);
int cmd_user(conn *c,char *arg);
int cmd_pass(conn *c,char *arg);
/* yoola.c */
void settimeout(conn *c,int secs);
void resettimeout(conn *c);
void unsettimeout(conn *c);
int set_nonblock(int fd);
int set_sockopts(int fd);
size_t a2b(char *buf,size_t len);
size_t b2a(char *buf,size_t len);
int writeall(int fd,const char *buf,size_t count);
char *uid2name(uid_t u);
char *gid2name(gid_t g);

