/* dataio.c   by Michael Thorpe   2004-06-23 */

#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "ftpd.h"

int daccept(conn *c) {
   int i;
   char *s;
   struct sockaddr_in sa;

   if(DMODE_PASSIVE != c->dmode || DSTATE_OPENING != c->dstate)
      return(1);
   i=sizeof(sa);
   i=accept(c->fdd,(struct sockaddr *)&sa,&i);
   if(i<0)
      return(1);
   s=inet_ntoa(sa.sin_addr);
   if(strcmp(s,c->raddr)) {
      close(i);
      if(log2(c,LOG_FAIL,"Got unexpected connection from ",s))
         return(1);
      return(0);
   }
   close(c->fdd);
#if REDO_NONBLOCK
   if(set_nonblock(i))
      return(1);
#endif
   c->fdd=i;
   c->dstate=DSTATE_OPEN;
   return(0);
}

int dconnect(conn *c) {
   int i,j;

   if(DMODE_ACTIVE != c->dmode || DSTATE_OPENING != c->dstate)
      return(1);
   j=sizeof(i);
   if(getsockopt(c->fdd,SOL_SOCKET,SO_ERROR,&i,&j) || j != sizeof(i)) {
      dclose(c,425);
      return(1);
   }
   if(i) {
      if(i==EINPROGRESS)
         return(0);
      dclose(c,425);
      return(1);
   }
   c->dstate=DSTATE_OPEN;
   return(0);
}

int dwrite(conn *c,char *buf,size_t len) {
   char *tmp;

   if(MAX_OUT_BUF<len+c->doutbuflen)
      return(1);
   tmp=(char *)realloc(c->doutbuf,len+c->doutbuflen);
   if(!tmp) {
      log(c,LOG_FAIL,"Couldn't allocate memory!");
      return(-1);
   }
   c->doutbuf=tmp;
   memcpy(c->doutbuf+c->doutbuflen,buf,len);
   c->doutbuflen+=len;
   return(0);
}

int dwriterec(conn *c,char *buf,size_t len) {
   char *tmp;

   if(MAX_OUT_BUF<len+2+c->doutbuflen)
      return(1);
   tmp=(char *)realloc(c->doutbuf,len+2+c->doutbuflen);
   if(!tmp) {
      log(c,LOG_FAIL,"Couldn't allocate memory!");
      return(-1);
   }
   c->doutbuf=tmp;
   memcpy(c->doutbuf+c->doutbuflen,buf,len);
   c->doutbuflen+=len;
   c->doutbuf[c->doutbuflen++]='\r';
   c->doutbuf[c->doutbuflen++]='\n';
   return(0);
}

int dflush(conn *c,int abort) {
   if(!abort && c->doutbuflen)
      return(dout(c));
   c->callback=0;
   return(dclose(c,0));
}

int dout(conn *c) {
   size_t i;
   char *tmp;

   if(c->doutbuflen) {
tryagain:
      i=write(c->fdd,c->doutbuf,c->doutbuflen);
      if(i<=0) {
         if(i==-1 && errno==EINTR)
            goto tryagain;
         if(i==-1 && errno != EAGAIN) {
            dclose(c,426);
            return(1);
         }
      } else if(i<c->doutbuflen) {
         memmove(c->doutbuf,c->doutbuf+i,c->doutbuflen-i);
         tmp=(char *)realloc(c->doutbuf,c->doutbuflen-i);
         if(tmp)
            c->doutbuf=tmp;
         c->doutbuflen-=i;
         resettimeout(c);
      } else {
         free(c->doutbuf);
         c->doutbuf=0;
         c->doutbuflen=0;
         resettimeout(c);
      }
   }
   return(0);
}

int dopen(conn *c,int direction) {
   int f;
   struct sockaddr_in sa;

   c->direction=direction;
   if(DSTATE_OPEN==c->dstate) {
      if(putline(c,125,0))
         return(1);
      return(0);
   }
   if(DMODE_ACTIVE==c->dmode && DSTATE_OPENING==c->dstate) {
      putline(c,451,0);
      dclose(c,0);
      return(1);
   }
   if(putline(c,150,0))
      return(1);
#if USE_PORT20
   f=bindaddrport(c->laddr,c->dlport);
#else
   f=bindaddrport(c->laddr,c->dlport==20?0:c->dlport);
#endif
   if(f<0)
      return(1);
   if(DMODE_ACTIVE==c->dmode) {
      memset(&sa,0,sizeof(sa));
      sa.sin_family=AF_INET;
      if(!inet_aton(c->raddr,(struct in_addr *)&sa.sin_addr)) {
         close(f);
         return(1);
      }
      sa.sin_port=htons(c->drport);
      if(!connect(f,(struct sockaddr *)&sa,sizeof(sa))) {
         c->dstate=DSTATE_OPEN;
      } else {
         if(errno != EINPROGRESS) {
            close(f);
            return(1);
         }
         c->dstate=DSTATE_OPENING;
      }
      c->fdd=f;
   }
   return(0);
}

int dclose(conn *c,int failure) {
   int i=0;

   if(c->callback)
      (c->callback)(c,1);
   switch(c->dstate) {
   case DSTATE_CLOSED:
      return(0);
   case DSTATE_OPEN:
   case DSTATE_OPENING:
      if('S' != c->mode && !failure) {
         if(putline(c,250,0))
            i++;
         c->dstate=DSTATE_OPEN;
         return(i);
      }
      break;
   }
   if(shutdown(c->fdd,2) && !failure)
      i++;
   if(close(c->fdd) && !failure)
      i++;
   c->fdd=-1;
   c->dstate=DSTATE_CLOSED;
   if(putline(c,failure?failure:226,0))
      i++;
   if(c->doutbuf) {
      free(c->doutbuf);
      c->doutbuf=0;
      c->doutbuflen=0;
   }
   return(i);
}

