/* main.c   by Michael Thorpe   2004-06-18 */

#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "ftpd.h"

static char *pid_file=PID_FILE;

static void reaper(int sig) {
   while(0<wait3(0,WNOHANG,0))
      ;
#if REDO_SIGNALS
   signal(SIGCHLD,reaper);
#endif
}

int writepid(char *file,pid_t pid) {
   int f;
   char s[12];

   f=open(file,O_WRONLY|O_CREAT|O_EXCL|O_NOCTTY,0644);
   if(f==-1) {
      if(errno==EEXIST) {
         log(0,LOG_NOTICE,"Refusing to overwrite pid file; please remove manually");
         return(1);
      }
      log(0,LOG_FAIL,"Couldn't open pid file");
      return(-1);
   }
   snprintf(s,sizeof(s),"%u\n",(unsigned int)pid);
   if(writeall(f,s,strlen(s))) {
      log(0,LOG_FAIL,"Couldn't write to pid file");
      close(f);
      return(-1);
   }
   if(close(f)) {
      log(0,LOG_FAIL,"Couldn't close pid file");
      return(-1);
   }
   return(0);
}

void pleasedie(int sig) {
   while(baselistener)
      dellistener(baselistener->addr,baselistener->cport);
}

int main(int argc,char **argv) {
/* This whole function should be redone and improved */
   unsigned short port=21;
   pid_t pid;

   if(argc>1)
      port=strtoul(argv[1],0,10);
   if(0==port || argc>4) {
      printf("usage: ftpd [<port> [<addr> [<external_addr>]]]\n");
      return(1);
   }
#ifndef DEBUG
   close(0);
   close(1);
#endif
   curpid=getpid();
   if(newlistener(argc>=3?argv[2]:0,port,argc>=4?argv[3]:0)) {
      fputs("Couldn't listen!\n",stderr);
      return(1);
   }
#ifndef DEBUG
   pid=fork();
   if(pid<0) {
      fputs("Couldn't fork!\n",stderr);
      return(1);
   } else if(pid>0)
      return(0);
   close(2);
#endif
   pid=curpid=getpid();
   if(pid_file && writepid(pid_file,pid))
      pid=0;
   signal(SIGINT,pleasedie);
   signal(SIGTERM,pleasedie);
   log(0,LOG_NOTICE,"Starting");
   signal(SIGCHLD,reaper);
   signal(SIGPIPE,SIG_IGN);
   signal(SIGHUP,reopenlog);
   close(2);
   chdir("/");
   doloop();
   log(0,LOG_NOTICE,"Exiting");
   if(pid_file && pid==curpid)
      unlink(pid_file);
   return(0);
}

