/* select.c   by Michael Thorpe   2004-06-23 */

#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include "ftpd.h"

void tvsubtract(struct timeval *dst,struct timeval *src) {
   if(dst->tv_sec<=src->tv_sec) {
      if(dst->tv_sec==src->tv_sec && dst->tv_usec>src->tv_usec) {
         dst->tv_sec=0;
         dst->tv_usec-=src->tv_usec;
      } else {
         dst->tv_sec=0;
         dst->tv_usec=0;
      }
   } else if(dst->tv_usec<src->tv_usec) {
      dst->tv_sec-=src->tv_sec+1;
      dst->tv_usec+=1000000-src->tv_usec;
   } else {
      dst->tv_sec-=src->tv_sec;
      dst->tv_usec-=src->tv_usec;
   }
}

#if !SANE_SELECT
int saneselect(int n,fd_set *r,fd_set *w,fd_set *e,struct timeval *timeout) {
   struct timeval start,stop;
   int retval;

   if(timeout) { 
      if(gettimeofday(&start,0))    
         return(-1);
   }
   retval=select(n,r,w,e,timeout);
   if(timeout) {
      if(gettimeofday(&stop,0))
         return(-1);
      tvsubtract(&stop,&start);
      tvsubtract(timeout,&stop);
   }
   return(retval);
}
#define select saneselect
#endif

void doloop() {
   int i;
   fd_set r,w,x;
   struct timeval tv,tv2,*tvp;
   conn *c,*c2;
   listener *l,*l2;

   while(1) {
      i=-1;
      FD_ZERO(&r);
      FD_ZERO(&w);
      FD_ZERO(&x);
      if(baseconn) {
         tv.tv_sec=baseconn->timeleft.tv_sec;
         tv.tv_usec=baseconn->timeleft.tv_usec;
      }
      for(c=baseconn;c;c=c->next) {
         if(tv.tv_sec>c->timeleft.tv_sec || (tv.tv_sec==c->timeleft.tv_sec && tv.tv_usec>c->timeleft.tv_usec)) {
            tv.tv_sec=c->timeleft.tv_sec;
            tv.tv_usec=c->timeleft.tv_usec;
         }
         i=i>c->fdc?i:c->fdc;
         if(c->coutbuflen)
            FD_SET(c->fdc,&w);
         else
            FD_SET(c->fdc,&r);
         FD_SET(c->fdc,&x);
         if(c->fdd != -1) {
            i=i>c->fdd?i:c->fdd;
            switch(c->dstate) {
            case DSTATE_OPEN:
               switch(c->direction) {
               case DIRECTION_IN:
                  FD_SET(c->fdd,&r);
                  break;
               case DIRECTION_OUT:
                  FD_SET(c->fdd,&w);
                  break;
               }
               break;
            case DSTATE_OPENING:
               switch(c->dmode) {
               case DMODE_ACTIVE:
                  FD_SET(c->fdd,&w);
                  break;
               case DMODE_PASSIVE:
                  FD_SET(c->fdd,&r);
                  break;
               }
               break;
            }
            FD_SET(c->fdd,&x);
         }
      }
      tvp=0;
      if(i != -1) {
         tv2.tv_sec=tv.tv_sec;
         tv2.tv_usec=tv.tv_usec;
         tvp=&tv2;
      }
      for(l=baselistener;l;l=l->next) {
         i=i>l->fdc?i:l->fdc;
         FD_SET(l->fdc,&r);
         FD_SET(l->fdc,&x);
      }
      if(i==-1)
         return;
#ifdef DEBUG
      if(baselistener)
         FD_SET(0,&r);
#endif
      if(-1==select(i+1,&r,&w,&x,tvp)) {
         if(errno==EINTR) {
            if(tvp) {
               tvsubtract(&tv,&tv2);
               for(c=baseconn;c;c=c2) {
                  c2=c->next;
                  tvsubtract(&c->timeleft,&tv);
                  if(!c->timeleft.tv_sec && !c->timeleft.tv_usec) {
                     putline(c,421,0);
                     delconn(c);
                  }
               }
            }
            continue;
         }
         log(0,LOG_FAIL,"select() returned weird error");
         return;
      }
#ifdef DEBUG
      if(baselistener && FD_ISSET(0,&r))
         while(baselistener)
            dellistener(baselistener->addr,baselistener->cport);
#endif
      if(tvp)
         tvsubtract(&tv,&tv2);
      for(c=baseconn;c;c=c2) {
         c2=c->next;
         tvsubtract(&c->timeleft,&tv);
         if(!c->timeleft.tv_sec && !c->timeleft.tv_usec) {
            putline(c,421,0);
            delconn(c);
            continue;
         }
         if(c->coutbuflen) {
            if(FD_ISSET(c->fdc,&w))
               if(cout(c)) {
                  delconn(c);
                  continue;
               }
         } else {
            if(FD_ISSET(c->fdc,&r))
               if(cin(c)) {
                  delconn(c);
                  continue;
               }
         }
         if(FD_ISSET(c->fdc,&x)) {
            delconn(c);
            continue;
         }
         if(c->fdd != -1) {
            if(FD_ISSET(c->fdd,&x)) {
               dclose(c,426);
               continue;
            }
            switch(c->dstate) {
            case DSTATE_OPEN:
               switch(c->direction) {
               case DIRECTION_IN:
                  if(FD_ISSET(c->fdd,&r))
                     if(c->callback(c,0))
                        continue;
                  break;
               case DIRECTION_OUT:
                  if(FD_ISSET(c->fdd,&w)) {
                     if(dout(c))
                        continue;
                     if(c->callback)
                        if(c->callback(c,0))
                           continue;
                  }
                  break;
               }
               break;
            case DSTATE_OPENING:
               switch(c->dmode) {
               case DMODE_ACTIVE:
                  if(FD_ISSET(c->fdd,&w))
                     if(dconnect(c))
                        continue;
                  break;
               case DMODE_PASSIVE:
                  if(FD_ISSET(c->fdd,&r))
                     if(daccept(c))
                        continue;
                  break;
               }
               break;
            }
         }
         if(c->state==STATE_CLOSE) {
            delconn(c);
            continue;
         }
      }
      for(l=baselistener;l;l=l2) {
         l2=l->next;
         if(FD_ISSET(l->fdc,&x))
            lerror(l);
         else if(FD_ISSET(l->fdc,&r))
            laccept(l);
      }
   }
}
