/* user.c   by Michael Thorpe   2004-06-18 */

#include <sys/types.h>
#include <grp.h>
#include <pwd.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "ftpd.h"
#if USE_SHADOW
#include <shadow.h>
#endif

#if USE_INITGROUPS
#if USE_SETFSID
#error "USE_INITGROUPS+USE_SETFSID doesn't make sense!"
#endif
#endif

static int changeto(uid_t uid,gid_t gid,char *username) {
   static uid_t curuid=BASE_UID;
   static gid_t curgid=BASE_GID;

#if USE_INITGROUPS
   if(curuid) {
      if(seteuid(0))
         return(1);
      curuid=0;
   }
   if(initgroups(username,gid))
      abort();
#endif
   if(curgid != gid) {
#if USE_SETFSID
      setfsgid(gid);
#else
      if(setegid(gid))
         return(1);
#endif
      curgid=gid;
   }
   if(curuid != uid) {
#if USE_SETFSID
      setfsuid(uid);
#else
      if(seteuid(uid))
         return(1);
#endif
      curuid=uid;
   }
   return(0);
}

int syncfsid(conn *c) {
#if !MODE_PERCONN
   if(changeto(c->uid,c->gid,c->user))
      return(1);
   if(c->cwd) {
      if(chdir(c->cwd)) {
         free(c->cwd);
         c->cwd=0;
         chdir("/");
      }
   } else {
      chdir("/");
   }
#endif
   return(0);
}

int dropuserid() {
#if !MODE_PERCONN
   if(changeto(BASE_UID,BASE_GID,BASE_USER))
      return(1);
   if(chdir("/"))
      return(1);
#endif
   return(0);
}

static int unbecomeuser(conn *c) {
   if(c->user) {
      free(c->user);
      c->user=0;
      unsettimeout(c);
   }
   if(changeto(BASE_UID,BASE_GID,BASE_USER))
      return(1);
   c->uid=BASE_UID;
   c->gid=BASE_GID;
#if !MODE_PERCONN
   if(c->cwd) {
      free(c->cwd);
      c->cwd=0;
   }
#endif
   chdir("/");
   return(0);
}

int cmd_rein(conn *c,char *arg) {
   if(c->username) {
      free(c->username);
      c->username=0;
   }
   if(c->user) {
      if(unbecomeuser(c))
         return(putline(c,530,0));
      unsettimeout(c);
   }
   if(c->callback)
      return(cmd_abor(c,0));
   return(putline(c,200,0));
}

int cmd_user(conn *c,char *arg) {
   if(c->username) {
      free(c->username);
      c->username=0;
   }
   if(c->user)
      if(unbecomeuser(c))
         return(putline(c,530,0));
   c->username=strdup(arg);
   if(!c->username)
      return(-1);
   return(putline(c,331,0));
}

int cmd_pass(conn *c,char *arg) {
   int i;
   struct passwd *sp;
#if USE_SHADOW
   struct spwd *ss;
#endif

   if(!c->username)
      return(putline(c,503,0));
   if(dropuserid()) {
      putline(c,530,0);
      return(1);
   }
   sp=getpwnam(c->username);
   if(!sp)
      return(putline(c,530,0));
#if USE_SHADOW
   setspent();
   ss=getspnam(c->username);
   if(!ss)
      return(putline(c,530,0));
   if(strcmp(ss->sp_pwdp,crypt(arg,ss->sp_pwdp)))
      return(putline(c,530,0));
   endspent();
#else
   if(strcmp(sp->pw_passwd,crypt(arg,sp->pw_passwd)))
      return(putline(c,530,0));
#endif
   c->uid=sp->pw_uid;
   c->gid=sp->pw_gid;
   if(changeto(sp->pw_uid,sp->pw_gid,c->username)) {
      putline(c,530,0);
      return(0);
   }
   if(chdir(sp->pw_dir)) {
      unbecomeuser(c);
      putline(c,530,0);
      return(0);
   }
#if !MODE_PERCONN
   c->cwd=strdup(sp->pw_dir);
   if(!c->cwd)
      return(1);
#endif
   i=log3(c,LOG_LOGIN,"User ",c->username," logged in");
   if(i)
      return(i);
   c->user=c->username;
   c->username=0;
   unsettimeout(c);
   return(putline(c,230,0));
}

