/* conf.h   by Michael Thorpe   2000-12-07 */

/************************************************************************/
/************************ WORKAROUNDS (REQUIRED) ************************/
/************************************************************************/

/* Do I need to reset signals after they are delivered? */
#define REDO_SIGNALS  1

/* Does O_NONBLOCK need to be reapplied after accept()? */
#define REDO_NONBLOCK  1

/* Does select() update the struct timeval with the remaining time? */
#define SANE_SELECT  1

/************************************************************************/
/*********************** CONFIGURATION (REQUIRED) ***********************/
/************************************************************************/

/* Do you want to use getspnam() for passwords instead of getpwnam()? */
#define USE_SHADOW  1

/* Should we use getprotobyname() instead of assuming 0? */
#define USE_PROTOENT  0

/************************************************************************/
/*********************** CONFIGURATION (OPTIONAL) ***********************/
/************************************************************************/

/* Do you want the server to fork for each client? */
#define MODE_PERCONN  0

/* Should we force the server to bind to port 20 for strict RFC compliance? */
#define USE_PORT20  0

/* What file should we log things to? */
#define LOG_FILE  "/var/log/ftp"

/* What file should we log our pid to? (Undefined disables pid-logging.) */
#define PID_FILE  "/var/run/ftpd.pid"

/* Do you want to allow filename globbing? (DANGER!) */
#define ALLOW_GLOBBING  0

/* Should SO_KEEPALIVE be used on connections? */
#define USE_KEEPALIVE  1

/* Should we use initgroups()? */
#define USE_INITGROUPS  0

/* Should we use setfs[ug]id() instead of sete[ug]id()? */
#define USE_SETFSID  0

/* What user/uid/gid should be used when not a user? */
#define BASE_USER  "root"
#define BASE_UID  0
#define BASE_GID  0

