/* dir.c   by Michael Thorpe   2000-11-09 */

#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#if ALLOW_GLOBBING
#include <glob.h>
#else
#include <dirent.h>
#endif
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/param.h>
#include "ftpd.h"

#define DIR_LINE_SIZE (61+2*MAXPATHLEN)

#if MAX_OUT_BUF < DIR_LINE_SIZE
#error "MAX_OUT_BUF must be larger than DIR_LINE_SIZE!"
#endif

static time_t now; /* Only valid during LIST callback */

static char *dostat(conn *c,char *file) {
   int i,j,k;
   char *l=0,*s,*t;
   struct stat st;
   struct tm *tm;

   if(lstat(file,&st))
      return(0);
   s=(char *)malloc(DIR_LINE_SIZE);
   if(!s)
      return(0);
   if(S_ISLNK(st.st_mode))
      s[0]='l';
   else if(S_ISREG(st.st_mode))
      s[0]='-';
   else if(S_ISDIR(st.st_mode))
      s[0]='d';
   else if(S_ISCHR(st.st_mode))
      s[0]='c';
   else if(S_ISBLK(st.st_mode))
      s[0]='b';
   else if(S_ISFIFO(st.st_mode))
      s[0]='p';
   else if(S_ISSOCK(st.st_mode))
      s[0]='s';
   else
      s[0]='?';
   s[1]=st.st_mode&0400?'r':'-';
   s[2]=st.st_mode&0200?'w':'-';
   s[3]=st.st_mode&0100?st.st_mode&04000?'s':'x':st.st_mode&04000?'S':'-';
   s[4]=st.st_mode&0040?'r':'-';
   s[5]=st.st_mode&0020?'w':'-';
   s[6]=st.st_mode&0010?st.st_mode&02000?'s':'x':st.st_mode&02000?'S':'-';
   s[7]=st.st_mode&0004?'r':'-';
   s[8]=st.st_mode&0002?'w':'-';
   s[9]=st.st_mode&0001?st.st_mode&01000?'t':'x':st.st_mode&01000?'T':'-';
   k=10;
   j=snprintf(s+k,DIR_LINE_SIZE-k," %3d ",st.st_nlink);
   if(j<0)
      goto fail;
   k+=j;
   if((t=uid2name(st.st_uid)))
      j=snprintf(s+k,DIR_LINE_SIZE-k,"%-8s ",t);
   else
      j=snprintf(s+k,DIR_LINE_SIZE-k,"%-8d ",st.st_uid);
   if(j<0)
      goto fail;
   k+=j;
   if((t=gid2name(st.st_gid)))
      j=snprintf(s+k,DIR_LINE_SIZE-k,"%-8s ",t);
   else
      j=snprintf(s+k,DIR_LINE_SIZE-k,"%-8d ",st.st_gid);
   if(j<0)
      goto fail;
   k+=j;
   if(S_ISBLK(st.st_mode) || S_ISCHR(st.st_mode))
      j=snprintf(s+k,DIR_LINE_SIZE-k,"%4d,%4d ",(st.st_rdev>>8)&255,st.st_rdev&255);
   else
      j=snprintf(s+k,DIR_LINE_SIZE-k,"%9d ",st.st_size);
   if(j<0)
      goto fail;
   k+=j;
   tm=localtime(&st.st_mtime);
/* strftime is a piece of shit; why no %d-without-leading-zero option? */
   if(st.st_mtime>now || st.st_mtime<now-15552000)
      j=strftime(s+k,DIR_LINE_SIZE-k,"%b %d  %Y ",tm);
   else
      j=strftime(s+k,DIR_LINE_SIZE-k,"%b %d %H:%M ",tm);
   if(j<0)
      goto fail;
   k+=j;
   i=strlen(file);
   l=0;
   if(S_ISLNK(st.st_mode)) {
      l=(char *)malloc(MAXPATHLEN+5);
      if(!l)
         goto fail;
      j=readlink(file,l+4,MAXPATHLEN);
      if(j<0)
         goto fail;
      l[j+4]='\0';
      l[0]=' ';
      l[1]='-';
      l[2]='>';
      l[3]=' ';
      i+=4+j;
   }
   t=(char *)realloc(s,i+k+1);
   if(!t)
      goto fail;
   s=t;
   strcat(s,file);
   if(l)
      strcat(s,l);
   return(s);
fail:
   free(l);
   free(s);
   return(0);
}

#if ALLOW_GLOBBING

static int dolist_cb(conn *c) {
   char *s;
   int z=426;

   if(c->state>=STATE_ABORT)
      goto fail;
   z=451;
   while(davail(c,DIR_LINE_SIZE)) {
      if(c->globpos>=c->glob.gl_pathc)
         goto done;
      if(c->dostat) {
         s=dostat(c,c->glob.gl_pathv[c->globpos]);
         if(!s) {
/* FIXME: This looks wrong... */
/*          putline(c,426,0); */
            goto fail;
         }
         if(dwriterec(c,s,strlen(s))) {
            free(s);
            goto fail;
         }
         free(s);
      } else
         if(dwriterec(c,c->glob.gl_pathv[c->globpos],strlen(c->glob.gl_pathv[c->globpos])))
            goto fail;
      c->globpos++;
   }
   return(0);
done:
   globfree(&c->glob);
   c->callback=dflush;
   return(dflush(c));
fail:
   globfree(&c->glob);
   c->callback=0;
   return(dclose(c,z));
}

static int dolist(conn *c,char *arg,int stat) {
   if(syncfsid(c))
      return(1);
   if(!arg[0])
      arg="*";
   if(glob(arg,GLOB_ERR|GLOB_PERIOD,0,&c->glob))
      return(putline(c,450,0));
   if(!c->glob.gl_pathc)
      return(putline(c,250,0));
   c->direction=DSTATE_OUT;
   if(dopen(c)) {
      globfree(&c->glob);
      return(putline(c,425,0));
   }
   c->globpos=0;
   if(-1==time(&now)) {
      globfree(&c->glob);
      return(putline(c,451,0));
   }
   c->callback=dolist_cb;
   c->dostat=stat;
   return(0);
}

#else /* #if ALLOW_GLOBBING */

static int dolist_cb(conn *c) {
   char *s;
   struct dirent *de;
   int z=426;

   if(c->state>=STATE_ABORT)
      goto fail;
   z=451;
   while(davail(c,DIR_LINE_SIZE)) {
      de=readdir(c->dir);
      if(!de)
         goto done;
      if(c->dostat) {
         s=dostat(c,de->d_name);
         if(!s) {
/* FIXME: This looks wrong... */
/*          putline(c,426,0); */
            goto fail;
         }
         if(dwriterec(c,s,strlen(s))) {
            free(s);
            goto fail;
         }
         free(s);
      } else {
         if(dwriterec(c,de->d_name,strlen(de->d_name)))
            goto fail;
      }
   }
   return(0);
done:
   closedir(c->dir);
   c->dir=0;
   c->callback=dflush;
   return(dflush(c));
fail:
   closedir(c->dir);
   c->dir=0;
   c->callback=0;
   return(dclose(c,z));
}

static int dolist(conn *c,char *arg,int stat) {
   DIR *d;

   if(syncfsid(c))
      return(1);
   d=opendir(".");
   if(!d)
      return(putline(c,450,0));
   c->direction=DSTATE_OUT;
   if(dopen(c)) {
      closedir(d);
      return(putline(c,425,0));
   }
   if(-1==time(&now)) {
      closedir(d);
      return(putline(c,451,0));
   }
   c->dir=d;
   c->callback=dolist_cb;
   c->dostat=stat;
   return(0);
}

#endif /* #if ALLOW_GLOBBING */

static int putdir(conn *c,int status,char *s) {
   int i,j;

   for(i=j=0;s[i];i++)
      if(s[i]=='"')
         j++;
   j+=i-2;
   while(s[i] != '"')
      s[j--]=s[i--];
   s[j--]=s[i--];
   while(i) {
      if(s[i]=='"')
         s[j--]='"';
      s[j--]=s[i--];
   }
   i=putline(c,status,s);
   free(s);
   return(i);
}

int cmd_cdup(conn *c,char *arg) {
   return(cmd_cwd(c,".."));
}

int cmd_cwd(conn *c,char *arg) {
   char *buf;

   if(syncfsid(c))
      return(1);
   if(chdir(arg))
      return(putline(c,550,0));
   buf=(char *)malloc(2*MAXPATHLEN+25);
   if(!buf)
      return(-1);
   buf[0]='"';
   if(!getcwd(buf+1,MAXPATHLEN)) {
      free(buf);
      return(-1);
   }
#if !MODE_PERCONN
   if(c->cwd)
      free(c->cwd);
   c->cwd=strdup(buf+1);
   if(!c->cwd) {
      free(buf);
      return(-1);
   }
#endif
   strcat(buf,"\" is the new directory.");
   return(putdir(c,250,buf));
}

int cmd_list(conn *c,char *arg) {
   return(dolist(c,arg,1));
}

int cmd_mkd(conn *c,char *arg) {
   int e=0;
   char *buf;

   if(syncfsid(c))
      return(1);
   if(mkdir(arg,0777)) {
      if(errno != EEXIST)
         return(putline(c,550,0));
      e=1;
   }
   buf=(char *)malloc(2*MAXPATHLEN+(e?29:22));
   if(!buf)
      return(-1);
   buf[0]='"';
   if(!realpath(arg,&buf[1]))
      return(putdir(c,451,0));
   if(e)
      strcat(buf,"\" directory already exists.");
   else
      strcat(buf,"\" directory created.");
   return(putdir(c,(e?521:257),buf));
}

int cmd_nlst(conn *c,char *arg) {
   return(dolist(c,arg,0));
}

int cmd_pwd(conn *c,char *arg) {
   char *buf;

   buf=(char *)malloc(2*MAXPATHLEN+29);
   if(!buf)
      return(-1);
   buf[0]='"';
#if MODE_PERCONN
   if(!getcwd(buf+1,MAXPATHLEN)) {
      free(buf);
      return(putline(c,550,0));
   }
#else
   strncpy(buf+1,c->cwd,MAXPATHLEN);
   buf[MAXPATHLEN+1]='\0';
#endif
   strcat(buf,"\" is the current directory.");
   return(putdir(c,257,buf));
}

int cmd_rmd(conn *c,char *arg) {
   int i;
   char *buf;

   if(syncfsid(c))
      return(1);
   if(rmdir(arg))
      return(putline(c,550,0));
   i=strlen(arg);
   buf=(char *)malloc(2*i+22);
   if(!buf)
      return(-1);
   buf[0]='"';
   strcpy(buf+1,arg);
   strcpy(&buf[i+1],"\" directory removed.");
   return(putdir(c,250,buf));
}

