/* log.c   by Michael Thorpe   2002-01-06 */

#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include "ftpd.h"

static FILE *logfile=0;
pid_t curpid;

static char *(logtype[])={"FAIL","NOTICE","LOGIN","CONNECT","DISCNCT","RETR","STOR","COMMAND","REPLY"};

static int preplog() {
   if(!logfile) {
#ifdef DEBUG
      logfile=stdout;
#else
      if(0==(logfile=fopen(LOG_FILE,"a")))
         return(-1);
#endif
   }
   return(0);
}

int log(conn *c,int type,char *s) {
   if(!((1<<type)&LOG_LEVEL))
      return(0);
   if(preplog())
      return(-1);
   if(!fprintf(logfile,"%u\t%s\t%s\t%s\n",(unsigned int)curpid,(c&&c->raddr?c->raddr:"-unknown-"),logtype[type],s))
      return(-1);
   fflush(logfile);
   return(0);
}

int log2(conn *c,int type,char *s1,char *s2) {
   if(!((1<<type)&LOG_LEVEL))
      return(0);
   if(preplog())
      return(-1);
   if(!fprintf(logfile,"%u\t%s\t%s\t%s%s\n",(unsigned int)curpid,(c&&c->raddr?c->raddr:"-unknown-"),logtype[type],s1,s2))
      return(-1);
   fflush(logfile);
   return(0);
}

int log3(conn *c,int type,char *s1,char *s2,char *s3) {
   if(!((1<<type)&LOG_LEVEL))
      return(0);
   if(preplog())
      return(-1);
   if(!fprintf(logfile,"%u\t%s\t%s\t%s%s%s\n",(unsigned int)curpid,(c&&c->raddr?c->raddr:"-unknown-"),logtype[type],s1,s2,s3))
      return(-1);
   fflush(logfile);
   return(0);
}

void reopenlog(int ignored) {
#ifndef DEBUG
   FILE *f;

   if(!logfile) {
      if(0==(f=freopen(LOG_FILE,"a",logfile))) {
         fprintf(logfile,"Fatal error! Couldn't reopen logfile!\n");
         fflush(logfile);
         abort();
      }
      if(f != logfile) {
         fprintf(f,"Semi-fatal error! Didn't get same FILE * on log reopen!\n");
         fflush(f);
         logfile=f;
      }
   }
#endif
   ignored=0;
#if REDO_SIGNALS
   signal(SIGHUP,reopenlog);
#endif
}

