/* yoola.c   by Michael Thorpe   2000-11-09 */

#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <grp.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "ftpd.h"

void settimeout(conn *c,int secs) {
   c->timeout=secs;
   c->timeleft.tv_sec=secs;
   c->timeleft.tv_usec=0;
}

void resettimeout(conn *c) {
   c->timeleft.tv_sec=c->timeout;
   c->timeleft.tv_usec=0;
}

void unsettimeout(conn *c) {
   settimeout(c,c->user?NORMAL_TIMEOUT:INITIAL_TIMEOUT);
}

/* FIXME: These next two functions should really be in net.c */
int set_nonblock(int fd) {
   int i;

   i=fcntl(fd,F_GETFL);
   if(i==-1) {
      log(0,LOG_FAIL,"Couldn't GETFL");
      return(1);
   }
   i |= O_NONBLOCK;
   if(fcntl(fd,F_SETFL,i)) {
      log(0,LOG_FAIL,"Couldn't SETFL");
      return(1);
   }
   return(0);
}

int set_sockopts(int fd) {
   int i;

   i=1;
   if(setsockopt(fd,SOL_SOCKET,SO_REUSEADDR,(void *)&i,sizeof(i))) {
      log(0,LOG_FAIL,"Couldn't set REUSEADDR");
      return(1);
   }
   i=1;
   if(setsockopt(fd,SOL_SOCKET,SO_OOBINLINE,(void *)&i,sizeof(i))) {
      log(0,LOG_FAIL,"Couldn't set OOBINLINE");
      return(1);
   }
#if USE_KEEPALIVE
   i=1;
   if(setsockopt(fd,SOL_SOCKET,SO_KEEPALIVE,(void *)&i,sizeof(i))) {
      log(0,LOG_FAIL,"Couldn't set KEEPALIVE");
      return(1);
   }
#endif
   return(set_nonblock(fd));
}

size_t a2b(char *buf,size_t len) {
   size_t i,j;

   for(i=0;i<len && buf[i] != '\r';i++)
      ;
   for(j=i++;i<len;i++)
      if(buf[i] != '\r')
         buf[j++]=buf[i];
   return(j);
}

size_t b2a(char *buf,size_t len) {
   size_t i,j=len,k;

   for(i=0;i<len;i++)
      if(buf[i]=='\n' || buf[i]=='\r')
         j++;
   k=j;
   while(i<j) {
      i--;
      if(buf[i]=='\n' || buf[i]=='\r') {
         buf[--j]='\n';
         buf[--j]='\r';
      } else
         buf[--j]=buf[i];
   }
   return(k);
}

int writeall(int fd,const char *buf,size_t count) {
   size_t i;

   while(count>0) {
      i=write(fd,buf,count);
      if(i<=0) {
         if(i==-1 && errno==EINTR)
            continue;
         return(1);
      }
      buf+=i;
      count-=i;
   }
   return(0);
}

char *uid2name(uid_t u) {
   static uid_t oldu;
   static char *olds=0;
   struct passwd *pw;

   if(!olds || u != oldu) {
      pw=getpwuid(oldu=u);
      if(!pw)
         return(0);
      olds=pw->pw_name;
   }
   return(olds);
}

char *gid2name(gid_t g) {
   static gid_t oldg;
   static char *olds=0;
   struct group *gr;

   if(!olds || g != oldg) {
      gr=getgrgid(oldg=g);
      if(!gr)
         return(0);
      olds=gr->gr_name;
   }
   return(olds);
}

